package gov.cms.grouper.snf;

import com.mmm.his.cer.foundation.ComponentVersion;
import com.mmm.his.cer.foundation.Processable;
import com.mmm.his.cer.foundation.utility.ComponentClassUtil;

public enum SnfComponentVersion implements ComponentVersion {
  v100,
  v104,
  v105,
  v109;

  /**
   * The value used for versioning a Java class path of the {@link Processable} implementation.<br>
   * <br>
   * The return string can be the name of a single package or it can be a partial package path with
   * package names separated by {@link ComponentClassUtil#PACKAGE_SEPARATOR}.<br>
   * <br>
   *
   * @return A valid Java class package name or partial path
   * @see ComponentClassUtil
   */
  @Override
  public String getPackageValue() {
    // TODO Kludge for current package setup, package should be updated to remove component package
    // TODO This will need to change to separate into individual package versions.
    return "component." + name();
  }
}
